@extends('admin.layout.template')
@section('title', 'Users')
@section('content')
<div class="page-content">
    <div class="container-xxl">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 py-0">
                <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{route('users.index')}}">Users</a></li>
            </ol>
        </nav>
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4>Users</h4>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#userModal">
                    + Add User
                </button>

            </div>

            <div class="card-body">
                <table id="usersTable" class="table  table-striped table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Role</th>
                            <th>Reporting Manager</th>
                            <th>Department</th>
                            <th>Status</th>
                            <th width="160">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $i => $user)
                        <tr id="row-{{ $user->id }}">
                            <td>{{ $i+1 }}</td>
                            <td>{{ $user->name }}
                                @if($user->isOnline())
                                <span class="badge bg-success">Online</span>
                                @else
                                <span class="badge bg-secondary">Offline</span>
                                @endif
                                <span class="d-flex align-items-center">
                            </td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->phone }}</td>
                            <td>{{ $user->roles->pluck('name')->first() }}</td>

                            {{-- Reporting Manager --}}
                            <td>{{ $user->manager ? $user->manager->name : '-' }}</td>

                            {{-- Department --}}
                            <td>{{ $user->department ? $user->department->name : '-' }}</td>

                            <td>

                                @if($user->status=='Active')
                                <span class="badge bg-success-subtle text-success py-1 px-2">{{$user->status}}</span>
                                @else
                                <span class="badge bg-success-subtle text-danger py-1 px-2">{{$user->status}}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('users.view', $user->id) }}" class="btn btn-sm btn-info">
                                    <iconify-icon icon="solar:eye-bold-duotone"></iconify-icon>

                                </a>

                                <button class="btn btn-sm btn-warning editUser" data-id="{{ $user->id }}">
                                    <iconify-icon icon="solar:pen-bold-duotone"></iconify-icon>
                                </button>
                                <button class="btn btn-sm btn-danger deleteUser" data-id="{{ $user->id }}">
                                    <iconify-icon icon="solar:trash-bin-trash-bold-duotone"></iconify-icon>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @include('admin.users.modal')

    </div>
</div>

<script>
    const usersBaseUrl = "{{ url('/users') }}";

    let assignedLocationsChoices;
    let assignedUserChoices;

    let departmentChoices;

    function initDepartmentChoices() {
        const el = document.querySelector('[name="department[]"]');
        if (!el) return;
        if (!departmentChoices) {
            departmentChoices = new Choices(el, {
                removeItemButton: true,
                allowHTML: true
            });
        }
    }

    // Call on page load
    document.addEventListener('DOMContentLoaded', function() {
        initDepartmentChoices();
    });


    function initAssignedUserChoices() {
        if (!assignedUserChoices) {
            const el = document.querySelector('#assigned_users');
            if (!el) return;
            assignedUserChoices = new Choices(el, {
                removeItemButton: true
            });
        }
    }

    // Call this **before** using assignedUserChoices
    function loadAssignedUsers(departmentIds, userId, selectedUsers = []) {
        initAssignedUserChoices(); // ensure it's initialized

        if (!assignedUserChoices) return; // still not found, exit

        assignedUserChoices.clearChoices();

        if (!departmentIds || departmentIds.length === 0) return;

        $.ajax({
            url: "{{ route('get.department.users', ':id') }}".replace(':id', departmentIds[0]),
            data: {
                user_id: userId
            },
            success: function(users) {
                assignedUserChoices.setChoices(
                    users.map(u => ({
                        value: u.id,
                        label: u.name,
                        selected: selectedUsers.includes(u.id)
                    })),
                    'value',
                    'label',
                    false
                );
            }
        });
    }






    $(document).ready(function() {
        $('#usersTable').DataTable({
            pageLength: 10,
            ordering: true,
            responsive: true
        });
    });
    /* ADD */
    $('#userForm').submit(function(e) {
        e.preventDefault();

        let id = $('#user_id').val();
        let url = id ? `${usersBaseUrl}/${id}` : usersBaseUrl;

        Swal.fire({
            title: 'Are you sure?',
            text: 'Save user details?',
            icon: 'question',
            showCancelButton: true
        }).then((res) => {
            if (res.isConfirmed) {
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: $(this).serialize() + (id ? '&_method=PUT' : ''),
                    success: function(res) {
                        Swal.fire('Success', res.message, 'success')
                            .then(() => location.reload());
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let errorMessages = [];

                            // Collect all error messages
                            for (const key in errors) {
                                if (errors.hasOwnProperty(key)) {
                                    errorMessages.push(errors[key].join('<br>'));
                                }
                            }

                            Swal.fire({
                                title: 'Validation Error',
                                html: errorMessages.join('<br>'),
                                icon: 'error'
                            });
                        } else {
                            Swal.fire('Error', 'Something went wrong!', 'error');
                        }
                    }
                });
            }
        });
    });


    /* EDIT */
    $('.editUser').click(function() {

        let id = $(this).data('id');
        $.get(
            "{{ route('users.edit', ':id') }}".replace(':id', id),
            function(res) {

                $('#user_id').val(res.user.id);

                $('[name=name]').val(res.user.name);
                $('[name=email]').val(res.user.email);
                $('[name=phone]').val(res.user.phone);

                $('#userModal').modal('show');

                $('[name="role"]').val(res.role).trigger('change');
                $('[name="status"]').val(res.user.status);
                $('[name="user_type"]').val(res.user.user_type);
                $('[name="department[]"]').val(res.department_ids).trigger('change');

                if (departmentChoices) {
                    departmentChoices.clearStore(); // clear previous options
                    departmentChoices.setChoices(
                        res.department_ids.map(id => {
                            const dept = res.departments.find(d => d.id === id);
                            return {
                                value: id,
                                label: dept.name,
                                selected: true
                            };
                        }),
                        'value',
                        'label',
                        false
                    );
                }

                $('[name="reporting_manager_id"]')
                    .val(res.reporting_manager_id)
                    .trigger('change');

                $('.assigned_locations')
                    .val(res.assigned_locations)
                    .trigger('change');

                $('[name="department[]"]')
                    .val(res.department_ids)
                    .trigger('change');

                loadAssignedUsers(
                    res.department_ids,
                    res.user.id,
                    res.assigned_users
                );
            }
        );

    });


    /* DELETE */
    $('.deleteUser').click(function() {
        let id = $(this).data('id');

        Swal.fire({
            title: 'Are you sure?',
            text: 'Delete user details?',
            icon: 'warning',
            showCancelButton: true
        }).then(res => {
            if (res.isConfirmed) {
                $.ajax({
                    url: "{{ route('users.destroy', ':id') }}".replace(':id', id),
                    type: 'POST',
                    data: {
                        _method: 'DELETE',
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(res) {
                        Swal.fire('Deleted', res.message, 'success');
                        $('#row-' + id).remove();
                    }
                })
            }
        });
    });

    $(document).on('change', '[name="department[]"]', function() {

        let departmentIds = $(this).val();
        let userId = $('#user_id').val();

        loadAssignedUsers(departmentIds, userId);
    });

    $(document).on('change', '[name="role"]', function() {
        let roleId = $(this).val();
        if (!roleId) return;

        $.get("{{ route('roles.departments', ':id') }}".replace(':id', roleId), function(departments) {
            // if (!departmentChoices) return;

            // Clear old options
            departmentChoices.clearChoices();

            // Add new departments
            departmentChoices.setChoices(
                departments.map(d => ({
                    value: d.id,
                    label: d.name
                })),
                'value',
                'label',
                false // do not select by default
            );
        });
    });
</script>

@endsection